typedef float float32_t;

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

#include <fenv.h>

void f ( float32_t x, float32_t y )
{
  float32_t z;

  feclearexcept ( FE_DIVBYZERO );        /* Non-compliant */

  z = x / y;

  if ( fetestexcept ( FE_DIVBYZERO ) )   /* Non-compliant */
  {
  }
  else
  {
#pragma STDC FENV_ACCESS ON

    z = x * y;
  }

  if ( z > x )
  {
#pragma STDC FENV_ACCESS OFF

    if ( fetestexcept ( FE_OVERFLOW ) )  /* Non-compliant */
    {
    }
  }
}

/* ------------------ Example code from MISRA C:2012 end ------------------ */
